/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.characterviewer;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import technology.rocketjump.undermount.assets.characterviewer.CharacterViewPersistentSettings;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetsByProfession;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidBodyType;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.factories.AccessoryColorFactory;
import technology.rocketjump.undermount.entities.factories.HairColorFactory;
import technology.rocketjump.undermount.entities.factories.SkinColorFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.Profession;

public class CharacterViewUI
implements Disposable {
    private final Profession defaultProfession;
    private Skin uiSkin = new Skin(Gdx.files.internal("assets/ui-skins/libgdx-default/uiskin.json"));
    private Stage stage;
    private Table containerTable;
    private TextButton hairColorButton;
    private TextButton skinColorButton;
    private TextButton accessoryColorButton;
    private Map<EntityAssetType, SelectBox> assetSelectWidgets = new HashMap<EntityAssetType, SelectBox>();
    private Entity currentEntity;
    private Map<EntityAssetType, EntityAsset> assetMap;
    private HumanoidEntityAttributes entityAttributes;
    private final HairColorFactory hairColorFactory;
    private final SkinColorFactory skinColorFactory;
    private final AccessoryColorFactory accessoryColorFactory;
    private final HumanoidEntityAssetDictionary assetDictionary;
    private final CharacterViewPersistentSettings persistentSettings;
    private final EntityAssetTypeDictionary assetTypeDictionary;
    private final EntityAssetUpdater entityAssetUpdater;

    @Inject
    public CharacterViewUI(HairColorFactory hairColorFactory, SkinColorFactory skinColorFactory, AccessoryColorFactory accessoryColorFactory, HumanoidEntityAssetDictionary assetDictionary, CharacterViewPersistentSettings persistentSettings, EntityAssetTypeDictionary assetTypeDictionary, ProfessionDictionary professionDictionary, EntityAssetUpdater entityAssetUpdater) {
        this.hairColorFactory = hairColorFactory;
        this.skinColorFactory = skinColorFactory;
        this.accessoryColorFactory = accessoryColorFactory;
        this.assetDictionary = assetDictionary;
        this.persistentSettings = persistentSettings;
        this.assetTypeDictionary = assetTypeDictionary;
        this.entityAssetUpdater = entityAssetUpdater;
        this.stage = new Stage(new ScreenViewport());
        this.containerTable = new Table(this.uiSkin);
        this.containerTable.setFillParent(true);
        this.stage.addActor(this.containerTable);
        this.defaultProfession = professionDictionary.getByName("VILLAGER");
        this.containerTable.pad(20.0f);
        this.containerTable.left().top();
    }

    public void init(Entity entity) {
        this.currentEntity = entity;
        this.entityAttributes = (HumanoidEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
        this.assetMap = entity.getPhysicalEntityComponent().getTypeMap();
        this.persistentSettings.reloadFromSettings(entity);
        this.containerTable.clearChildren();
        this.createRaceWidgets();
        this.containerTable.row();
        this.createGenderWidget();
        this.containerTable.row();
        this.createBodyTypeWidget();
        this.containerTable.row();
        this.createHairColorWidget();
        this.containerTable.row();
        this.createSkinColorWidget();
        this.containerTable.row();
        this.createAccessoryColorWidget();
        this.containerTable.row();
        this.createAssetWidget("Eyebrows", this.assetTypeDictionary.getByName("HUMANOID_EYEBROWS"));
        this.containerTable.row();
        this.createAssetWidget("Beard", this.assetTypeDictionary.getByName("HUMANOID_BEARD"));
        this.containerTable.row();
        this.createAssetWidget("Hair", this.assetTypeDictionary.getByName("HUMANOID_HAIR"));
        this.containerTable.row();
        this.createAssetWidget("Clothes", this.assetTypeDictionary.getByName("BODY_CLOTHING"));
        this.updateAttributes(this.entityAttributes);
    }

    private void resetAssetSelections() {
        Profession primaryProfession = this.currentEntity.getComponent(ProfessionsComponent.class).getPrimaryProfession(this.defaultProfession);
        for (Map.Entry<EntityAssetType, SelectBox> entry : this.assetSelectWidgets.entrySet()) {
            Array<String> newItems = new Array<String>();
            for (HumanoidEntityAsset entityAsset : this.assetDictionary.getAllMatchingAssets(entry.getKey(), this.entityAttributes, primaryProfession)) {
                newItems.add(entityAsset.getUniqueName());
            }
            newItems.add("None");
            entry.getValue().setItems(newItems);
            HumanoidEntityAsset entityAsset = (HumanoidEntityAsset)this.assetMap.get(entry.getKey());
            entry.getValue().setSelected(entityAsset.getUniqueName());
        }
    }

    private void createAssetWidget(String label, final EntityAssetType assetType) {
        this.containerTable.add(new Label((CharSequence)(label + ": "), this.uiSkin));
        final SelectBox widget = new SelectBox(this.uiSkin);
        Array<String> assetNames = new Array<String>();
        final Profession primaryProfession = this.currentEntity.getComponent(ProfessionsComponent.class).getPrimaryProfession(this.defaultProfession);
        List<HumanoidEntityAsset> matchingAssetsWithSameType = this.assetDictionary.getAllMatchingAssets(assetType, this.entityAttributes, primaryProfession);
        for (HumanoidEntityAsset asset : matchingAssetsWithSameType) {
            assetNames.add(asset.getUniqueName());
        }
        assetNames.add("None");
        widget.setItems(assetNames);
        if (this.assetMap.get(assetType) != null) {
            HumanoidEntityAsset entityAsset = (HumanoidEntityAsset)this.assetMap.get(assetType);
            widget.setSelected(entityAsset.getUniqueName());
        }
        widget.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                HumanoidEntityAsset selectedAsset;
                List<HumanoidEntityAsset> matchingAssetsWithSameType = CharacterViewUI.this.assetDictionary.getAllMatchingAssets(assetType, CharacterViewUI.this.entityAttributes, primaryProfession);
                Optional<HumanoidEntityAsset> matchedAsset = matchingAssetsWithSameType.stream().filter(asset -> asset.getUniqueName().equalsIgnoreCase((String)widget.getSelected())).findFirst();
                if (matchedAsset.isPresent()) {
                    selectedAsset = matchedAsset.get();
                } else if (((String)widget.getSelected()).equalsIgnoreCase("None")) {
                    selectedAsset = HumanoidEntityAssetsByProfession.NULL_ENTITY_ASSET;
                } else {
                    System.err.println("Error: Could not find asset with name " + (String)widget.getSelected());
                    return;
                }
                CharacterViewUI.this.assetMap.put(assetType, selectedAsset);
                CharacterViewUI.this.persistentSettings.update(assetType, selectedAsset);
            }
        });
        this.containerTable.add(widget);
        this.assetSelectWidgets.put(assetType, widget);
    }

    private void createBodyTypeWidget() {
        this.containerTable.add(new Label((CharSequence)"Body type: ", this.uiSkin));
        final SelectBox bodyTypeSelect = new SelectBox(this.uiSkin);
        Array<String> bodyTypeItems = new Array<String>();
        for (HumanoidBodyType bodyType : HumanoidBodyType.values()) {
            bodyTypeItems.add(bodyType.name().toLowerCase());
        }
        bodyTypeItems.removeValue(HumanoidBodyType.ANY.name().toLowerCase(), false);
        bodyTypeSelect.setItems(bodyTypeItems);
        bodyTypeSelect.setSelected(this.entityAttributes.getBodyType().name().toLowerCase());
        bodyTypeSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                HumanoidBodyType selectedType = HumanoidBodyType.valueOf(((String)bodyTypeSelect.getSelected()).toUpperCase());
                CharacterViewUI.this.entityAttributes.setBodyType(selectedType);
                CharacterViewUI.this.entityAssetUpdater.updateEntityAssets(CharacterViewUI.this.currentEntity);
                CharacterViewUI.this.persistentSettings.setBodyType(selectedType);
                CharacterViewUI.this.resetAssetSelections();
            }
        });
        this.containerTable.add(bodyTypeSelect);
    }

    private void createGenderWidget() {
        final SelectBox<String> genderSelect = new SelectBox<String>(this.uiSkin);
        genderSelect.setItems("Male", "Female");
        genderSelect.setSelected(this.entityAttributes.getGender().equals((Object)Gender.MALE) ? "Male" : "Female");
        genderSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gender selectedGender = Gender.valueOf(((String)genderSelect.getSelected()).toUpperCase());
                CharacterViewUI.this.entityAttributes.setGender(selectedGender);
                CharacterViewUI.this.entityAssetUpdater.updateEntityAssets(CharacterViewUI.this.currentEntity);
                CharacterViewUI.this.persistentSettings.setGender(selectedGender);
                CharacterViewUI.this.resetAssetSelections();
            }
        });
        this.containerTable.add(new Label((CharSequence)"Gender:", this.uiSkin), genderSelect);
    }

    private void createSkinColorWidget() {
        this.containerTable.add(new Label((CharSequence)"Skin color: ", this.uiSkin));
        this.skinColorButton = new TextButton("#RRGGBB", this.uiSkin);
        this.skinColorButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Color newColor = CharacterViewUI.this.skinColorFactory.randomSkinColor(new RandomXS128());
                CharacterViewUI.this.entityAttributes.setSkinColor(newColor);
                CharacterViewUI.this.persistentSettings.setSkinColor(newColor);
                CharacterViewUI.this.updateAttributes(CharacterViewUI.this.entityAttributes);
            }
        });
        this.containerTable.add(this.skinColorButton);
    }

    private void createAccessoryColorWidget() {
        this.containerTable.add(new Label((CharSequence)"Accessory color: ", this.uiSkin));
        this.accessoryColorButton = new TextButton("#RRGGBB", this.uiSkin);
        this.accessoryColorButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Color newColor = CharacterViewUI.this.accessoryColorFactory.randomAccessoryColor(new RandomXS128());
                CharacterViewUI.this.entityAttributes.setAccessoryColor(newColor);
                CharacterViewUI.this.persistentSettings.setAccessoryColor(newColor);
                CharacterViewUI.this.updateAttributes(CharacterViewUI.this.entityAttributes);
            }
        });
        this.containerTable.add(this.accessoryColorButton);
    }

    private void createHairColorWidget() {
        this.containerTable.add(new Label((CharSequence)"Hair color: ", this.uiSkin));
        this.hairColorButton = new TextButton("#rrggbb", this.uiSkin);
        this.hairColorButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Color newColor = CharacterViewUI.this.hairColorFactory.randomHairColor(new RandomXS128());
                CharacterViewUI.this.entityAttributes.setHairColor(newColor);
                CharacterViewUI.this.persistentSettings.setHairColor(newColor);
                CharacterViewUI.this.updateAttributes(CharacterViewUI.this.entityAttributes);
            }
        });
        this.containerTable.add(this.hairColorButton);
    }

    private void createRaceWidgets() {
        SelectBox<Object> raceSelect = new SelectBox<Object>(this.uiSkin);
        raceSelect.setItems("Dwarf");
        raceSelect.setSelected("Dwarf");
        this.containerTable.add(new Label((CharSequence)"Race:", this.uiSkin), raceSelect);
    }

    public void render() {
        this.stage.act();
        this.stage.draw();
    }

    public void onResize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    public void updateAttributes(HumanoidEntityAttributes entityAttributes) {
        this.entityAttributes = entityAttributes;
        this.hairColorButton.setColor(entityAttributes.getColor(ColoringLayer.HAIR_COLOR));
        this.hairColorButton.setText("#" + entityAttributes.getColor(ColoringLayer.HAIR_COLOR).toString().substring(0, 6));
        this.skinColorButton.setColor(entityAttributes.getColor(ColoringLayer.SKIN_COLOR));
        this.skinColorButton.setText("#" + entityAttributes.getColor(ColoringLayer.SKIN_COLOR).toString().substring(0, 6));
        this.accessoryColorButton.setColor(entityAttributes.getColor(ColoringLayer.ACCESSORY_COLOR));
        this.accessoryColorButton.setText("#" + entityAttributes.getColor(ColoringLayer.ACCESSORY_COLOR).toString().substring(0, 6));
    }

    public Stage getStage() {
        return this.stage;
    }
}

